package ru.yandex.chemodan.videostreaming.framework.hls.ffmpeg.transcoding;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;
import lombok.experimental.NonFinal;

import ru.yandex.misc.dataSize.DataSize;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Value
@NonFinal
@AllArgsConstructor
@Builder(toBuilder = true)
public class HlsFFmpegCommandParams {
    public static final HlsFFmpegCommandParams DEFAULT =
            new HlsFFmpegCommandParams(2, 0, false, DataSize.fromBytes(-1));

    String argFillerName;

    int inputThreads;

    int outputThreads;

    boolean useGapless;

    DataSize recvBufferSize;

    public HlsFFmpegCommandParams(int inputThreads, int outputThreads, boolean useGapless, DataSize recvBufferSize) {
        this("default", inputThreads, outputThreads, useGapless, recvBufferSize);
    }
}
