package ru.yandex.chemodan.videostreaming.framework.hls.ffmpeg.transcoding;

import ru.yandex.chemodan.videostreaming.framework.hls.HlsSegmentRegion;
import ru.yandex.chemodan.videostreaming.framework.media.units.MediaTime;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class HlsMuxerSegmentOpts {

    private static final MediaTime END_OFFSET = MediaTime.millis(240);

    private final HlsSegmentRegion segment;

    public HlsMuxerSegmentOpts(HlsSegmentRegion segment) {
        this.segment = segment;
    }

    public MediaTime getStart() {
        return segment.getStart();
    }

    public MediaTime getOutputDuration() {
        return getSegmentDuration()
                .plus(END_OFFSET);
    }

    public MediaTime getSegmentDuration() {
        return segment.getDuration();
    }

    public boolean isFirst() {
        return getStart().equals(MediaTime.ZERO);
    }

    public boolean isLast() {
        return segment.isLast();
    }

    public Integer getSegmentStartNumber() {
        return segment.getIndex();
    }
}
