package ru.yandex.chemodan.videostreaming.framework.hls.framesegment;

import org.junit.Test;

import ru.yandex.chemodan.videostreaming.framework.media.units.Fraction;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class FrameAwareStreamTest {
    @Test
    public void testFrm7Seg34() {
        new AssertFrameSegment(7, 34)
                .calcPositionEqualsForSegNum(0, 28, 0)
                .calcPositionEqualsForSegNum(28, 35, 1)
                .calcPositionEqualsForSegNum(63, 35, 2)
                .calcPositionEqualsForSegNum(98, 35, 3)
                .calcPositionEqualsForSegNum(133, 35, 4)
                .calcPositionEqualsForSegNum(168, 35, 5)
                .calcPositionEqualsForSegNum(203, 35, 6)
                .calcPositionEqualsForSegNum(238, 28, 7)
                .calcPositionEqualsForSegNum(266, 35, 8);
    }
    @Test
    public void testFrm11Seg35() {
        new AssertFrameSegment(11, 35)
                .calcPositionEqualsForSegNum(0, 33, 0)
                .calcPositionEqualsForSegNum(33, 33, 1)
                .calcPositionEqualsForSegNum(66, 33, 2)
                .calcPositionEqualsForSegNum(99, 33, 3)
                .calcPositionEqualsForSegNum(132, 33, 4)
                .calcPositionEqualsForSegNum(165, 44, 5)
                .calcPositionEqualsForSegNum(209, 33, 6)
                .calcPositionEqualsForSegNum(242, 33, 7)
                .calcPositionEqualsForSegNum(275, 33, 8);
    }

    private static class AssertFrameSegment {
        final FrameAwareStream stream;

        AssertFrameSegment(int frmLen, int segLen) {
            stream = new FrameAwareStream(
                    new Fraction(frmLen, 1),
                    new Fraction(segLen, 1)
            );
        }

        AssertFrameSegment calcPositionEqualsForSegNum(long startNumerator, long lenNumerator, int segNum) {
            Fraction start = new Fraction(startNumerator, 1);
            Fraction len = new Fraction(lenNumerator, 1);
            Assert.equals(FrameAwareStream.Segment.fromStartAndDuration(start, len), stream.getSegment(segNum));
            return this;
        }
    }
}
