package ru.yandex.chemodan.videostreaming.framework.hls.segmentprovider;

import java.io.InputStream;
import java.util.function.Consumer;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.FFmpegCommand;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.FFmpegCommandBuilder;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsFFmpegSourceProvider;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsOutputProvider;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsSegmentMeta;
import ru.yandex.chemodan.videostreaming.framework.hls.ffmpeg.transcoding.FFmpegMapping;
import ru.yandex.chemodan.videostreaming.framework.hls.ffmpeg.transcoding.HlsFFmpegCommandContext;
import ru.yandex.chemodan.videostreaming.framework.hls.ffmpeg.transcoding.HlsFFmpegCommandParams;
import ru.yandex.chemodan.videostreaming.framework.hls.ffmpeg.transcoding.HlsMuxerSegmentOpts;
import ru.yandex.chemodan.videostreaming.framework.hls.segmentprovider.argfiller.FFmpegArgFillerRegistry;
import ru.yandex.chemodan.videostreaming.framework.hls.segmentprovider.argfiller.FFmpegFillParams;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class HlsFFmpegCommandProvider<T> {
    @SuppressWarnings("unused")
    private static final Logger logger = LoggerFactory.getLogger(HlsFFmpegCommandProvider.class);

    private final FFmpegArgFillerRegistry argFillerRegistry;

    private final HlsFFmpegSourceProvider<T> sourceProvider;

    private final HlsOutputProvider outputProvider;

    private final HlsFFmpegCommandParams commandParams;

    public HlsFFmpegCommandProvider(FFmpegArgFillerRegistry argFillerRegistry,
            HlsFFmpegSourceProvider<T> sourceProvider, HlsOutputProvider outputProvider,
            HlsFFmpegCommandParams commandParams)
    {
        this.argFillerRegistry = argFillerRegistry;
        this.sourceProvider = sourceProvider;
        this.outputProvider = outputProvider;
        this.commandParams = commandParams;
    }

    public FFmpegCommandAndFillParams get(HlsSegmentMeta<T> segmentMeta, Consumer<InputStream> consumer) {
        FFmpegCommandBuilder builder = new FFmpegCommandBuilder(
                sourceProvider.get(segmentMeta.getSourceMeta()),
                outputProvider.getOutput(segmentMeta, consumer)
        );
        HlsFFmpegCommandContext ctx = new HlsFFmpegCommandContext(
                segmentMeta.stream,
                new HlsMuxerSegmentOpts(segmentMeta.region),
                commandParams,
                FFmpegMapping.fromFileInfo(segmentMeta.getFileInformation())
        );
        Option<FFmpegFillParams> fillParams = argFillerRegistry.get(commandParams.getArgFillerName()).fill(builder, ctx);
        FFmpegCommand command = builder.build()
                .withDuration(ctx.getOutDuration());
        return new FFmpegCommandAndFillParams(command, fillParams);
    }
}
