package ru.yandex.chemodan.videostreaming.framework.hls.segmentprovider;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.FFmpegOutput;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.FFmpegSource;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsFFmpegSourceProvider;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsOutputProvider;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsResource;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsSegmentMeta;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsSegmentRegion;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsStreamQuality;
import ru.yandex.chemodan.videostreaming.framework.hls.ffmpeg.transcoding.HlsFFmpegCommandParams;
import ru.yandex.chemodan.videostreaming.framework.hls.ffmpeg.transcoding.TestHelper;
import ru.yandex.chemodan.videostreaming.framework.hls.segmentprovider.argfiller.FFmpegArgFillerRegistry;
import ru.yandex.chemodan.videostreaming.framework.media.units.MediaTime;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.io.http.UriBuilder;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@RunWith(MockitoJUnitRunner.class)
public class HlsFFmpegCommandProviderTest {
    @Mock
    private HlsFFmpegSourceProvider<Object> sourceProvider;

    @Mock
    private HlsOutputProvider outputProvider;

    @Before
    public void init() {
        Mockito.when(sourceProvider.get(Mockito.any()))
                .thenReturn(FFmpegSource.cons(new UriBuilder("http://localhost/source").build()));
        Mockito.when(outputProvider.getOutput(Mockito.any(), Mockito.any()))
                .thenReturn(FFmpegOutput.uri("http://localhost/target"));
    }

    @Test
    public void testCommand() {
        ListF<String> expectedList = Cf.list(
                "-async", "1",
                "-gapless",
                "-ss", "00:05",
                "-t", "00:05.240",
                "-threads", "2",
                "-recv_buffer_size", "1048576",

                "-i", "http://localhost/source",

                "-threads", "3",
                "-s", "1280x720",
                "-force_key_frames", "expr:if(isnan(prev_forced_t),gte(t,0),gte(t,prev_forced_t+5))",

                "-map", "0:1",
                "-map", "0:2",

                "-b:v", "5120k",
                "-bufsize", "10240k",
                "-maxrate", "6144k",
                "-vcodec", "h264",
                "-profile:v", "baseline",
                "-level", "3.0",
                "-pix_fmt", "yuv420p",
                "-preset", "veryfast",

                "-b:a", "128k",
                "-acodec", "aac",
                "-strict", "-2",

                "-sn",

                "-f", "ssegment",
                "-segment_format", "mpegts",
                "-segment_start_number", "1",
                "-initial_offset", "5",
                "-segment_time", "5",

                "-r", "25.0",

                "http://localhost/target"
        );
        ListF<String> actualList = conSut().get(consSegmentMeta(), in -> {})
                .getCommand()
                .toStringList();
        try {
            Assert.assertListsEqual(expectedList, actualList);
        } catch (AssertionError e) {
            System.out.println(expectedList);
            System.out.println(actualList);
            throw e;
        }
    }

    private HlsSegmentMeta<Object> consSegmentMeta() {
        HlsResource.Stream stream = TestHelper.buildHlsResource()
                .getStream(HlsStreamQuality._720P);
        HlsSegmentRegion segmentRegion = new HlsSegmentRegion(1, MediaTime.seconds(5), stream);
        return new HlsSegmentMeta<>(stream, segmentRegion, new Object());
    }

    private HlsFFmpegCommandProvider<Object> conSut() {
        return new HlsFFmpegCommandProvider<>(new FFmpegArgFillerRegistry(),
                sourceProvider, outputProvider,
                new HlsFFmpegCommandParams(2, 3, true, DataSize.fromBytes(1048576))
        );
    }
}
