package ru.yandex.chemodan.videostreaming.framework.hls.segmentprovider.argfiller;

import java.util.Collection;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.MapF;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class FFmpegArgFillerRegistry {
    static final MapF<String, FFmpegArgFiller> DEFAULT_FILLERS = Cf.map(
            "default", DefaultFFmpegArgFiller.DEFAULT,
            "experiment", DefaultFFmpegArgFiller.EXPERIMENT,
            // TODO: remove after full migration to "frm1809" arg filler
            "audio-sympathetic2", DefaultFFmpegArgFiller.DEFAULT
    );

    volatile MapF<String, FFmpegArgFiller> argFillers;

    public FFmpegArgFillerRegistry() {
        this(Cf.map());
    }

    public FFmpegArgFillerRegistry(MapF<String, FFmpegArgFiller> extraArgFillers) {
        this.argFillers = extraArgFillers.plus(DEFAULT_FILLERS);
    }

    public FFmpegArgFiller get(String key) {
        return argFillers.getTs(key);
    }

    public synchronized void changeArgFillers(
            MapF<String, FFmpegArgFiller> argFillersToPut,
            Collection<String> keysToRemove)
    {
        argFillers.putAll(argFillersToPut);
        argFillers.keySet().removeAllTs(keysToRemove);
    }

    public CollectionF<String> getKeys() {
        return argFillers.keys();
    }
}
