package ru.yandex.chemodan.videostreaming.framework.hls.segmentprovider.argfiller;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.function.Function;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.RegistryDiffListener;
import ru.yandex.commune.zk2.primitives.registry.ZkRegistry;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.BenderParserSerializer;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class FFmpegArgFillerZkRegistry extends ZkRegistry<String, ZkJsFFmpegArgFiller>
        implements RegistryDiffListener<ZkJsFFmpegArgFiller>
{
    private static final BenderParserSerializer<ZkJsFFmpegArgFiller> parserSerializer =
            Bender.cons(ZkJsFFmpegArgFiller.class);

    private final FFmpegArgFillerRegistry argFillerRegistry;

    public FFmpegArgFillerZkRegistry(ZkPath zkPath, FFmpegArgFillerRegistry argFillerRegistry) {
        super(zkPath, parserSerializer, ZkJsFFmpegArgFiller::getName, Function.identityF());
        this.argFillerRegistry = argFillerRegistry;
        addListener(this);
    }

    @Override
    public void put(ZkJsFFmpegArgFiller argFiller) {
        argFiller.validate();
        super.put(argFiller);
    }

    @Override
    public synchronized void changedWith(
            CollectionF<ZkJsFFmpegArgFiller> added,
            CollectionF<ZkJsFFmpegArgFiller> updated,
            CollectionF<ZkJsFFmpegArgFiller> removed)
    {
        argFillerRegistry.changeArgFillers(
                added.plus(updated)
                        .toMapMappingToKey(ZkJsFFmpegArgFiller::getName)
                        .mapValues(ZkJsFFmpegArgFiller::toArgFiller),
                removed.map(ZkJsFFmpegArgFiller::getName)
        );
    }
}
