package ru.yandex.chemodan.videostreaming.framework.hls.segmentprovider.argfiller;

import java.net.URI;

import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

import lombok.Getter;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.FFmpegCommandBuilder;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.FFmpegOutput;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.FFmpegSource;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.FFmpegTimeDurationUtil;
import ru.yandex.chemodan.videostreaming.framework.hls.FrameSegment;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsResource;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsSegmentRegion;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsStreamQuality;
import ru.yandex.chemodan.videostreaming.framework.hls.ffmpeg.transcoding.FFmpegMapping;
import ru.yandex.chemodan.videostreaming.framework.hls.ffmpeg.transcoding.HlsFFmpegCommandContext;
import ru.yandex.chemodan.videostreaming.framework.hls.ffmpeg.transcoding.HlsFFmpegCommandParams;
import ru.yandex.chemodan.videostreaming.framework.hls.ffmpeg.transcoding.HlsMuxerSegmentOpts;
import ru.yandex.chemodan.videostreaming.framework.hls.ffmpeg.transcoding.TestHelper;
import ru.yandex.chemodan.videostreaming.framework.hls.framesegment.FrameAwareStreamPair;
import ru.yandex.chemodan.videostreaming.framework.media.units.FrameRate;
import ru.yandex.chemodan.videostreaming.framework.media.units.MediaTime;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@BenderBindAllFields
public class ZkJsFFmpegArgFiller extends DefaultObject {
    public static final ZkJsFFmpegArgFiller EMPTY = new ZkJsFFmpegArgFiller("", "");

    public static final BenderParserSerializer<ZkJsFFmpegArgFiller> parserSerializer =
            Bender.cons(ZkJsFFmpegArgFiller.class);

    @Getter
    private final String name;

    private final String script;

    public ZkJsFFmpegArgFiller(String name, String script) {
        this.name = name;
        this.script = script;
    }

    public static ZkJsFFmpegArgFiller parse(byte[] json) {
        return parserSerializer.getParser()
                .parseJson(json);
    }

    public byte[] toJson() {
        return parserSerializer.getSerializer()
                .serializeJson(this);
    }

    public void validate() {
        FFmpegArgFiller argFiller = toArgFiller();
        FFmpegCommandBuilder builder = new FFmpegCommandBuilder(
                FFmpegSource.cons(URI.create("http://localhost/source")),
                FFmpegOutput.uri("http://localhost/target")
        );
        HlsResource hlsResource = TestHelper.buildHlsResource();
        HlsResource.Stream stream = hlsResource.getStream(HlsStreamQuality._720P);
        HlsFFmpegCommandContext context = new HlsFFmpegCommandContext(
                stream,
                new HlsMuxerSegmentOpts(new HlsSegmentRegion(10, MediaTime.seconds(5), stream)),
                HlsFFmpegCommandParams.DEFAULT,
                FFmpegMapping.fromFileInfo(hlsResource.fileInformation)
        );
        argFiller.fill(builder, context);
    }

    public FFmpegArgFiller toArgFiller() {
        ScriptEngine engine = createScriptEngine();
        try {
            engine.getBindings(ScriptContext.ENGINE_SCOPE)
                    .put("ru", engine.eval("Packages.ru"));
            engine.eval("load('nashorn:mozilla_compat.js')");
            engine.eval("importPackage(ru.yandex.bolts.collection)");
            engine.eval("importPackage(org.joda.time)");
            engine.eval("importPackage(ru.yandex.chemodan.videostreaming.framework.media.units)");
            engine.eval("FrameRate = " + FrameRate.class.getCanonicalName());
            engine.eval("FrameSegment = " + FrameSegment.class.getCanonicalName());
            engine.eval("FrameAwareStreamPair = " + FrameAwareStreamPair.class.getCanonicalName());
            engine.eval("FFmpegFillParams = " + FFmpegFillParams.class.getCanonicalName());
            engine.eval("formatTime = " + FFmpegTimeDurationUtil.class.getCanonicalName() + ".format");
            engine.eval("formatTimeInSeconds = " + FFmpegTimeDurationUtil.class.getCanonicalName()
                    + ".formatInSeconds");
            engine.eval("function fillArgs(cmd, ctx) {\n" + script + "\n}");
        } catch (ScriptException e) {
            throw ExceptionUtils.translate(e);
        }
        Invocable inv = (Invocable) engine;
        return (cmd, ctx) -> {
            try {
                Object result = inv.invokeFunction("fillArgs", cmd, ctx);
                return result instanceof FFmpegFillParams ? Option.of((FFmpegFillParams) result) : Option.empty();
            } catch (ScriptException | NoSuchMethodException e) {
                throw ExceptionUtils.translate(e);
            }
        };
    }

    private ScriptEngine createScriptEngine() {
        ScriptEngine nashornEngine = createScriptEngine("nashorn");
        return nashornEngine != null ? nashornEngine : createGraalScriptEngine();
    }

    private ScriptEngine createGraalScriptEngine() {
        System.setProperty("polyglot.js.nashorn-compat", "true");
        return createScriptEngine("graal.js");
    }

    private ScriptEngine createScriptEngine(String engineName) {
        return new ScriptEngineManager().getEngineByName(engineName);
    }
}
