package ru.yandex.chemodan.videostreaming.framework.hls.segmentprovider.argfiller;

import java.net.URI;

import org.junit.Test;
import org.mockito.Mockito;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.FFmpegCommandBuilder;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.FFmpegOutput;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.FFmpegSource;
import ru.yandex.chemodan.videostreaming.framework.hls.ffmpeg.transcoding.HlsFFmpegCommandContext;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class ZkJsFFmpegArgFillerTest {
    static final String ARG_FILLER_JSON = "{'name':'test','script':'cmd.in(\\\"-threads\\\", ctx.inThreads);'}";

    @Test
    public void parse() {
        String json = ARG_FILLER_JSON
                .replaceAll("'", "\"");
        Assert.equals(
                new ZkJsFFmpegArgFiller("test", "cmd.in(\"-threads\", ctx.inThreads);"),
                ZkJsFFmpegArgFiller.parse(json.getBytes())
        );
    }

    @Test
    public void serialize() {
        Assert.equals(
                ARG_FILLER_JSON
                        .replaceAll("'", "\""),
                new String(new ZkJsFFmpegArgFiller("test", "cmd.in(\"-threads\", ctx.inThreads);").toJson())
        );
    }

    @Test
    public void correctJsArgFillerWorksCorrectly() {
        ZkJsFFmpegArgFiller argFiller = new ZkJsFFmpegArgFiller("test",
                "cmd.in('-threads', ctx.inThreads)"
                        + ".out('-threads', ctx.outThreads)"
        );
        FFmpegCommandBuilder cmdBuilder = new FFmpegCommandBuilder(
                FFmpegSource.cons(URI.create("http://localhost/source")),
                FFmpegOutput.uri("http://localhost/output")
        );
        HlsFFmpegCommandContext ctx = Mockito.mock(HlsFFmpegCommandContext.class);
        Mockito.when(ctx.getInThreads())
                .thenReturn(2);
        Mockito.when(ctx.getOutThreads())
                .thenReturn(3);
        argFiller.toArgFiller()
                .fill(cmdBuilder, ctx);
        Assert.equals(
                Cf.list("-threads", "2",
                        "-i", "http://localhost/source",
                        "-threads", "3",
                        "http://localhost/output"
                ),
                cmdBuilder.build().toStringList()
        );
    }
}
