function addVideoParams(cmd) {
    cmd.out("-s", ctx.dimension) // set frame size (WxH or abbreviation)
        .out("-force_key_frames",
            java.lang.String.format("expr:if(isnan(prev_forced_t),gte(t,%s),gte(t,prev_forced_t+%s))",
                formatTimeInSeconds(Duration.ZERO),
                formatTimeInSeconds(ctx.segmentDuration)
            )
        );
}

function addVideoCodecParams(cmd) {
    cmd.out("-b:v", "" + ctx.videoBitRate.kbps + "k")
        .out("-bufsize", "" + Math.max(1835, ctx.videoBitRate.kbps * 2) + "k")
        .out("-maxrate", "" + ctx.videoBitRate.kbps * 6 / 5 + "k")

        .out("-vcodec", "h264")
        .out("-profile:v", "baseline")
        .out("-level", "3.0")
        .out("-pix_fmt", "yuv420p")

        .out("-preset", "veryfast")

        // .out("-sc_threshold", 0)
    ;
}

function addAudioCodecParams(cmd) {
    cmd.out("-b:a", ctx.audioBitRateO.get().kbps + "k")
        .out("-acodec", "aac")
        .out("-strict", "-2");
}

// cmd.out("-vf",
//     "drawtext=fontfile='/usr/local/java8/jre/lib/fonts/LucidaTypewriterRegular.ttf'"
//     + ":text='%{pts\\:hms}':fontcolor=white:fontsize=100"
//     + ":box=1:boxcolor=black@0.5:boxborderw=5"
//     + ":x=(w-text_w)/2:y=(h-text_h)/2"
// );

cmd
    // simplified 1 parameter audio timestamp matching
    // 0(disabled), 1(filling and trimming), >1(maximum stretch/squeeze in samples per second)
    .inIf("-async", "1", ctx.notFirstSegment)

    .inIf("-gapless", ctx.useGapless)

    // MUST NOT be set for first segment!
    // see https://wiki.yandex-team.ru/disk/videostreaming/ffmpeg-params/#param-ss
    .inIf("-ss", formatTime(ctx.segmentStart), ctx.notFirstSegment)

    .in("-t", formatTime(ctx.outDuration))

    .in("-threads", ctx.inThreads)

    // .add("-seekable", 1) // Control seekability of connection.
    // .add("-multiple_requests", 1) // Use persistent connections if set to 1, default is 0

    // https://wiki.yandex-team.ru/disk/videostreaming/ffmpeg-params/#param-recv_buffer_size
    .in("-recv_buffer_size", ctx.recvBufferSize.toBytes())

    .out("-threads", ctx.outThreads)

    .out("-r", 25.0)

    .applyIf(addVideoParams, ctx.hasVideo())

    .outO(ctx.mappingO.map(function(mapping) { return mapping.args; }))

    .applyIf(addVideoCodecParams, ctx.hasVideo())
    .elseOut("-vn")

    .applyIf(addAudioCodecParams, ctx.hasAudio())
    .elseOut("-an")

    .out("-sn")

    .out("-f", "ssegment")
    .out("-segment_format", "mpegts")
    .out("-segment_start_number", ctx.segmentStartNumber)
    .out("-initial_offset", formatTimeInSeconds(ctx.segmentStart))
    .out("-segment_time", formatTimeInSeconds(ctx.segmentDuration));
