package ru.yandex.chemodan.videostreaming.framework.hls.segmentprovider.caching;

import java.io.IOException;
import java.io.InputStream;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.videostreaming.framework.hls.segmentprovider.HlsSegmentSource;
import ru.yandex.misc.io.ByteArrayInputStreamSource;
import ru.yandex.misc.io.InputStreamSource;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class CacheData {
    public static final CacheData ABSENT = new CacheData();

    public static final CacheData IN_PROGRESS = new CacheData();

    private final Option<InputStreamSource> inSrcO;

    private final Option<Source> sourceO;

    public CacheData(byte[] data) {
        this(new ByteArrayInputStreamSource(data), Source.CACHE);
    }

    public CacheData(InputStreamSource inSrc, Source source) {
        this(Option.of(inSrc), Option.of(source));
    }

    private CacheData() {
        this(Option.empty(), Option.empty());
    }

    private CacheData(Option<InputStreamSource> inSrcO, Option<Source> sourceO) {
        this.inSrcO = inSrcO;
        this.sourceO = sourceO;
    }

    public static CacheData fromCache(InputStreamSource inSrc) {
        return new CacheData(inSrc, Source.CACHE);
    }

    public static CacheData fromPrefetch(InputStreamSource inSrc) {
        return new CacheData(inSrc, Source.PREFETCH);
    }

    public boolean isPresent() {
        return inSrcO.isPresent();
    }

    public boolean isInProgress() {
        return this == IN_PROGRESS;
    }

    public boolean isNotEmpty() {
        return isInProgress() || isPresent();
    }

    public InputStream getInput() throws IOException {
        return inSrcO.get().getInput();
    }

    public Source getSource() {
        return sourceO.get();
    }

    public enum Source {
        CACHE, PREFETCH;

        public HlsSegmentSource toSegmentSource() {
            switch(this) {
                case CACHE:
                    return HlsSegmentSource.CACHE;

                case PREFETCH:
                    return HlsSegmentSource.PREFETCH;

                default:
                    throw new IllegalStateException(
                            "Can't convert " + this + " to " + HlsSegmentSource.class.getSimpleName()
                    );
            }
        }
    }
}
