package ru.yandex.chemodan.videostreaming.framework.hls.segmentprovider.caching;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsSegmentMeta;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsStreamQuality;
import ru.yandex.chemodan.videostreaming.framework.media.units.MediaTime;
import ru.yandex.misc.io.InputStreamSource;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public interface HlsSegmentCache<T> {
    CacheData getCacheData(HlsSegmentMeta<T> segmentMeta);

    void put(HlsSegmentMeta<T> segmentMeta, InputStreamSource iss);

    default boolean prepare(HlsSegmentMeta<T> segmentMeta) {
        return true;
    }

    default SegmentIndexes getCachedSegmentIndexes(T sourceMeta, HlsStreamQuality quality,
            MediaTime duration)
    {
        return new SegmentIndexes(Cf.list());
    }

    default void clearCacheForSource(T sourceMeta) {
        throw new UnsupportedOperationException();
    }
}
