package ru.yandex.chemodan.videostreaming.framework.hls.segmentprovider.caching;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsSegmentMeta;
import ru.yandex.misc.cache.Cache;
import ru.yandex.misc.cache.CacheUtils;
import ru.yandex.misc.io.InputStreamSource;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@SuppressWarnings("unused")
public class InMemoryHlsSegmentCache<T> implements HlsSegmentCache<T> {
    private final Cache<HlsSegmentMeta<T>, byte[]> cache = CacheUtils.newLru(300);

    @Override
    public CacheData getCacheData(HlsSegmentMeta<T> segmentMeta) {
        return Option.x(cache.getFromCache(segmentMeta))
                .map(CacheData::new)
                .getOrElse(CacheData.ABSENT);
    }

    @Override
    public void put(HlsSegmentMeta<T> segmentMeta, InputStreamSource iss) {
        cache.putInCache(segmentMeta, iss.readBytes());
    }
}
