package ru.yandex.chemodan.videostreaming.framework.hls.segmentprovider.caching;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class SegmentIndexesTest {
    private static final SegmentIndexes SUT = new SegmentIndexes(
            Cf.list(
                    Cf.range(5, 9),
                    Cf.range(17, 23),
                    Cf.range(29, 30)
            )
    );

    @Test
    public void testContains() {
        assertContains(7);
        assertContains(22);
        assertContains(29);
    }

    @Test
    public void testNotContains() {
        assertNotContains(4);
        assertNotContains(9);
        assertNotContains(123);
    }

    private static void assertContains(int index) {
        Assert.isTrue(SUT.contains(index));
    }

    private static void assertNotContains(int index) {
        Assert.isFalse(SUT.contains(index));
    }
}
