package ru.yandex.chemodan.videostreaming.framework.hls.segmentprovider.prefetch;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.FFmpegStats;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.FFmpegStatsHandler;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsSegmentMeta;
import ru.yandex.chemodan.videostreaming.framework.util.CommonThreadPoolHolder;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class SegmentPrefetchFFmpegStatsHandler<T> implements FFmpegStatsHandler {
    private final HlsSegmentPrefetch<T> segmentPrefetch;

    private final HlsSegmentMeta<T> segmentMeta;

    private final HlsSegmentPrefetchTrigger trigger;

    private volatile int prefetchedCount;

    private final int maxPrefetchCount;

    public SegmentPrefetchFFmpegStatsHandler(
            HlsSegmentPrefetch<T> segmentPrefetch,
            HlsSegmentMeta<T> segmentMeta,
            HlsSegmentPrefetchTrigger trigger,
            int initialPrefetchCount,
            int maxPrefetchCount)
    {
        this.segmentPrefetch = segmentPrefetch;
        this.segmentMeta = segmentMeta;
        this.trigger = trigger;
        this.prefetchedCount = initialPrefetchCount;
        this.maxPrefetchCount = maxPrefetchCount;
    }

    @Override
    public void handle(FFmpegStats stats) {
        CommonThreadPoolHolder.runAsync(() -> process(stats));
    }

    private void process(FFmpegStats stats) {
        int countToPrefetch = Math.max(trigger.prefetch(stats), maxPrefetchCount);
        if (prefetchedCount >= countToPrefetch) {
            return;
        }

        synchronized (this) {
            while(prefetchedCount < countToPrefetch) {
                prefetchedCount++;

                Option<HlsSegmentMeta<T>> segmentMetaO = segmentMeta.getSiblingIfExistsO(prefetchedCount);
                if (segmentMetaO.isPresent()) {
                    CommonThreadPoolHolder.runAsync(() -> segmentPrefetch.prefetch(segmentMetaO.get()));
                }
            }
        }
    }
}
