package ru.yandex.chemodan.videostreaming.framework.hls.sourcemeta;

import java.util.function.Function;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class SourceMetaConverter<T> {
    private final String paramName;

    private final Function<T, String> converterF;

    public SourceMetaConverter(String paramName, Function<T, String> converterF) {
        this.paramName = paramName;
        this.converterF = converterF;
    }

    public static <T> SourceMetaConverter<T> defaultConverter() {
        return new SourceMetaConverter<>("src_id", Object::toString);
    }

    public String getParamName() {
        return paramName;
    }

    public String convert(T sourceMeta) {
        return converterF.apply(sourceMeta);
    }
}
