package ru.yandex.chemodan.videostreaming.framework.hls.sourcemeta;

import ru.yandex.chemodan.videostreaming.framework.web.HlsErrorSource;
import ru.yandex.chemodan.videostreaming.framework.web.StreamingHttpServletRequest;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public interface SourceMetaParser<T> {
    T parse(StreamingHttpServletRequest request);

    abstract class SourceMetaException extends RuntimeException {
        public final Object sourceMeta;

        SourceMetaException(Object sourceMeta) {
            this.sourceMeta = sourceMeta;
        }
    }

    class AccessForbiddenException extends SourceMetaException implements HlsErrorSource {
        public AccessForbiddenException(Object sourceMeta) {
            super(sourceMeta);
        }

        @Override
        public HlsError getHlsError() {
            return new HlsError(HttpStatus.SC_403_FORBIDDEN, "Access forbidden");
        }
    }

    class LinkExpiredException extends SourceMetaException implements HlsErrorSource {
        public LinkExpiredException(Object sourceMeta) {
            super(sourceMeta);
        }

        @Override
        public HlsError getHlsError() {
            return new HlsError(HttpStatus.SC_410_GONE, "Link expired");
        }
    }

    class SourceNotSpecifiedException extends RuntimeException implements HlsErrorSource {
        @Override
        public HlsError getHlsError() {
            return new HlsError(HttpStatus.SC_400_BAD_REQUEST, "source not specified");
        }
    }
}
