package ru.yandex.chemodan.videostreaming.framework.hls.stats;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.videostreaming.framework.media.MediaInfo;
import ru.yandex.chemodan.videostreaming.framework.util.system.AppCpuTime;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public interface FFUtilStats {
    Option<MediaInfo> getFileInformationO();

    void setFileInformation(MediaInfo fileInformation);

    Option<AppCpuTime.Interval> getFFmpegAppCpuTimeO();

    default void setFFmpegAppCpuTime(AppCpuTime.Interval cpuTime) {
        setFFmpegAppCpuTimeO(Option.of(cpuTime));
    }

    void setFFmpegAppCpuTimeO(Option<AppCpuTime.Interval> cpuTimeO);

    Option<AppCpuTime.Interval> getFFprobeAppCpuTimeO();

    void setFFprobeAppCpuTime(AppCpuTime.Interval cpuTime);

    static void runWithNew(Runnable runnable) {
        FFUtilStatsImpl.runWithNew(runnable);
    }

    static FFUtilStats getCurrent() {
        return FFUtilStatsImpl.getCurrentO()
                .map(stats -> (FFUtilStats) stats)
                .getOrElse(NOOP);
    }

    FFUtilStats NOOP = new FFUtilStats() {
        @Override
        public Option<MediaInfo> getFileInformationO() {
            return Option.empty();
        }

        @Override
        public void setFileInformation(MediaInfo fileInformation) {
            // do nothing
        }

        @Override
        public Option<AppCpuTime.Interval> getFFmpegAppCpuTimeO() {
            return Option.empty();
        }

        @Override
        public void setFFmpegAppCpuTimeO(Option<AppCpuTime.Interval> cpuTimeO) {
            // do nothing
        }

        @Override
        public Option<AppCpuTime.Interval> getFFprobeAppCpuTimeO() {
            return Option.empty();
        }

        @Override
        public void setFFprobeAppCpuTime(AppCpuTime.Interval cpuTime) {
            // do nothing
        }
    };
}
