package ru.yandex.chemodan.videostreaming.framework.hls.stats;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.videostreaming.framework.media.MediaInfo;
import ru.yandex.chemodan.videostreaming.framework.util.system.AppCpuTime;
import ru.yandex.chemodan.videostreaming.framework.util.threadlocal.ReplicableThreadLocal;

public class FFUtilStatsImpl implements FFUtilStats {
    private static final ReplicableThreadLocal<FFUtilStatsImpl> threadLocal = new ReplicableThreadLocal<>();

    private volatile Option<MediaInfo> fileInformationO = Option.empty();

    private volatile Option<AppCpuTime.Interval> ffmpegAppCpuTimeO = Option.empty();

    private volatile Option<AppCpuTime.Interval> ffprobeAppCpuTimeO = Option.empty();

    @Override
    public Option<MediaInfo> getFileInformationO() {
        return fileInformationO;
    }

    @Override
    public void setFileInformation(MediaInfo fileInformation) {
        this.fileInformationO = Option.of(fileInformation);
    }

    @Override
    public Option<AppCpuTime.Interval> getFFmpegAppCpuTimeO() {
        return ffmpegAppCpuTimeO;
    }

    @Override
    public void setFFmpegAppCpuTimeO(Option<AppCpuTime.Interval> cpuTimeO) {
        this.ffmpegAppCpuTimeO = cpuTimeO;
    }

    @Override
    public Option<AppCpuTime.Interval> getFFprobeAppCpuTimeO() {
        return ffprobeAppCpuTimeO;
    }

    @Override
    public void setFFprobeAppCpuTime(AppCpuTime.Interval cpuTime) {
        this.ffprobeAppCpuTimeO = Option.of(cpuTime);
    }

    public static void runWithNew(Runnable runnable) {
        threadLocal.runWith(new FFUtilStatsImpl(), runnable);
    }

    public static Option<FFUtilStatsImpl> getCurrentO() {
        return threadLocal.getO();
    }
}
