package ru.yandex.chemodan.videostreaming.framework.hls.stats;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.videostreaming.framework.hls.segmentprovider.HlsSegmentSource;
import ru.yandex.chemodan.videostreaming.framework.media.units.MediaTime;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public interface HlsRequestStats {
    Instant getCreatedAt();

    Option<HlsSegmentSource> getSourceO();

    void setSource(HlsSegmentSource source);

    Option<MediaTime> getDurationO();

    void setDuration(MediaTime duration);

    static void runWithNew(Runnable runnable) {
        HlsRequestStatsImpl.runWithNew(runnable);
    }

    static HlsRequestStats getCurrent() {
        return HlsRequestStatsImpl.getCurrentO()
                .map(stats -> (HlsRequestStats) stats)
                .getOrElse(NOOP);
    }

    HlsRequestStats NOOP = new HlsRequestStats() {
        @Override
        public Instant getCreatedAt() {
            return Instant.now();
        }

        @Override
        public Option<HlsSegmentSource> getSourceO() {
            return Option.empty();
        }

        @Override
        public void setSource(HlsSegmentSource source) {
            // do nothing
        }

        @Override
        public Option<MediaTime> getDurationO() {
            return Option.empty();
        }

        @Override
        public void setDuration(MediaTime duration) {
            // do nothing
        }
    };
}
