package ru.yandex.chemodan.videostreaming.framework.hls.stats;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.videostreaming.framework.hls.segmentprovider.HlsSegmentSource;
import ru.yandex.chemodan.videostreaming.framework.media.units.MediaTime;
import ru.yandex.chemodan.videostreaming.framework.util.threadlocal.ReplicableThreadLocal;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class HlsRequestStatsImpl extends DefaultObject implements HlsRequestStats {
    private static final ReplicableThreadLocal<HlsRequestStatsImpl> threadLocal = new ReplicableThreadLocal<>();

    private final Instant createdAt = Instant.now();

    private volatile Option<HlsSegmentSource> sourceO = Option.empty();

    private volatile Option<MediaTime> durationO = Option.empty();

    @Override
    public Instant getCreatedAt() {
        return createdAt;
    }

    @Override
    public Option<HlsSegmentSource> getSourceO() {
        return sourceO;
    }

    @Override
    public void setSource(HlsSegmentSource source) {
        this.sourceO = Option.of(source);
    }

    @Override
    public Option<MediaTime> getDurationO() {
        return durationO;
    }

    @Override
    public void setDuration(MediaTime duration) {
        this.durationO = Option.of(duration);
    }

    public static void runWithNew(Runnable runnable) {
        threadLocal.runWith(new HlsRequestStatsImpl(), runnable);
    }

    public static Option<HlsRequestStatsImpl> getCurrentO() {
        return threadLocal.getO();
    }
}
