package ru.yandex.chemodan.videostreaming.framework.hls.videoinfo;

import ru.yandex.chemodan.videostreaming.framework.ffmpeg.FFmpeg;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsFFmpegSourceProvider;
import ru.yandex.chemodan.videostreaming.framework.media.MediaInfo;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class HlsFFmpegVideoInfoProvider<T> implements HlsVideoInfoProvider<T> {
    private final FFmpeg ffmpeg;

    private final HlsFFmpegSourceProvider<T> sourceProvider;

    public HlsFFmpegVideoInfoProvider(FFmpeg ffmpeg, HlsFFmpegSourceProvider<T> sourceProvider) {
        this.ffmpeg = ffmpeg;
        this.sourceProvider = sourceProvider;
    }

    @Override
    public MediaInfo getVideoInfo(T sourceMeta) {
        return ffmpeg.videoInformation(sourceProvider.get(sourceMeta));
    }
}
