package ru.yandex.chemodan.videostreaming.framework.hls.videoinfo;

import ru.yandex.chemodan.videostreaming.framework.hls.HlsResource;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsResponse;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsUrlBuilder;
import ru.yandex.chemodan.videostreaming.framework.hls.sourcemeta.SourceMetaTransformer;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class HlsVideoInfoManager<T> {
    private final StreamingResourceProvider<T> resourceProvider;

    private final HlsUrlBuilder<T> urlBuilder;

    private final SourceMetaTransformer<T> sourceMetaTransformer;

    public HlsVideoInfoManager(StreamingResourceProvider<T> resourceProvider, HlsUrlBuilder<T> urlBuilder,
            SourceMetaTransformer<T> sourceMetaTransformer)
    {
        this.resourceProvider = resourceProvider;
        this.urlBuilder = urlBuilder;
        this.sourceMetaTransformer = sourceMetaTransformer;
    }

    public void handleRequest(T sourceMeta, HlsResponse resp) {
        HlsResource resource = getHlsResource(sourceMeta);
        handleRequestInternal(sourceMetaTransformer.transform(sourceMeta, resource), resp);
    }

    private void handleRequestInternal(T sourceMeta, HlsResponse resp) {
        HlsResource hlsResource = getHlsResource(sourceMeta);
        resp.consumeContent(
                VideoInfo.cons(hlsResource,
                        urlBuilder.getMasterPlaylistUrl(sourceMeta).toString(),
                        quality -> urlBuilder.getPlaylistUrl(sourceMeta, quality).toString())
                        .toJson(),
                "application/json"
        );
    }

    private HlsResource getHlsResource(T sourceMeta) {
        return resourceProvider.getResource(sourceMeta);
    }
}
