package ru.yandex.chemodan.videostreaming.framework.hls.videoinfo;

import ru.yandex.bolts.function.Function1B;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsResource;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsStreamQuality;
import ru.yandex.chemodan.videostreaming.framework.media.MediaInfo;
import ru.yandex.chemodan.videostreaming.framework.web.HlsErrorSource;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class StreamingResourceProvider<T> {
    private static final Function1B<HlsStreamQuality> FILTER_720P =
            q -> q.getHeight() <= HlsStreamQuality._720P.getHeight();

    private final HlsVideoInfoProvider<T> resourceProvider;

    private final StreamingResourceParams params;

    public StreamingResourceProvider(HlsVideoInfoProvider<T> resourceProvider, StreamingResourceParams params) {
        this.resourceProvider = resourceProvider;
        this.params = params;
    }

    public HlsResource getResource(T sourceMeta) {
        MediaInfo fileInfo = resourceProvider.getVideoInfo(sourceMeta);
        if (!fileInfo.getVideoStreamO().isPresent() && !fileInfo.getAudioStreamO().isPresent()) {
            throw new NoVideoAndAudioException();
        }
        return new HlsResource(fileInfo, params.isEnableSeparateAudio())
                .filterQualities(params.isEnableFullHd() ? Function1B.trueF() : FILTER_720P);
    }

    public static class NoVideoAndAudioException extends RuntimeException implements HlsErrorSource {
        @Override
        public HlsError getHlsError() {
            return new HlsError(HttpStatus.SC_422_UNPROCESSABLE_ENTITY,
                    "Resource contains neither video, nor audio");
        }
    }
}
