package ru.yandex.chemodan.videostreaming.framework.hls.videoinfo;

import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.ffprobe.FFprobeInfo;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.ffprobe.FFprobeSharedFixtures;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsResource;
import ru.yandex.chemodan.videostreaming.framework.hls.HlsStreamQuality;
import ru.yandex.chemodan.videostreaming.framework.media.MediaInfo;
import ru.yandex.chemodan.videostreaming.framework.media.units.MediaTime;
import ru.yandex.misc.image.Dimension;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class VideoInfoTest {
    private static final Dimension DIMENSION = new Dimension(1920, 1080);

    private static final MediaInfo MEDIA_INFO = new MediaInfo(
            new FFprobeInfo(
                    FFprobeSharedFixtures.FORMAT_MKV_1HR.toBuilder()
                            .duration(MediaTime.minutes(2))
                            .build(),
                    FFprobeSharedFixtures.VIDEO_1080P_24FPS.toBuilder()
                            .dimension(DIMENSION)
                            .build()
            ), "");

    @Test
    public void testJson() {
        int countOfQualities = HlsStreamQuality.getSuitableFor(DIMENSION).length() + /* audio only */ 1;
        Assert.equals(
                "{"
                        + "\"stream_id\":\"CmNfLCzdYhJOSKgSL3VbD+F6QelsxVlAOPcmAsBoT8s=\","
                        + "\"duration\":120000,"
                        + "\"total\":" + countOfQualities + ","
                        + "\"items\":["
                        + StringUtils.join(HlsStreamQuality.MASTER_QUALITIES.map(VideoInfoTest::getPlaylistJson),
                        ",")
                        + "," + getPlaylistItem("adaptive", "http://t/p.m3u8", Option.empty())
                        + "],"
                        + "\"orig_dimension\":{\"width\":1920,\"height\":1080}"
                        + "}",
                new String(
                        VideoInfo.cons(
                                new HlsResource(MEDIA_INFO),
                                "http://t/p.m3u8",
                                quality -> "http://t/" + quality.toRequestParamValue() + "/p.m3u8"
                        ).toJson()
                )
        );
    }

    private static String getPlaylistJson(HlsStreamQuality quality) {
        String qualityStr = quality.toRequestParamValue();
        return getPlaylistItem(qualityStr, "http://t/" + qualityStr + "/p.m3u8",
                Option.of(quality.getDimensionFor(MEDIA_INFO.getVideoStream()))
        );
    }

    private static String getPlaylistItem(String quality, String url, Option<Dimension> dimension) {
        String dimensionStr = dimension.map(d -> ",\"width\":" + d.getWidth() + ",\"height\":" + d.getHeight())
                .getOrElse("");
        return "{\"resolution\":\"" + quality + "\","
                + "\"links\":{\"http\":\"" + url + "\"},"
                + "\"video_codec\":\"H.264\","
                + "\"audio_codec\":\"AAC\","
                + "\"container\":\"hls\""
                + dimensionStr
                + "}";

    }
}
