package ru.yandex.chemodan.videostreaming.framework.hls.videoinfo;

import ru.yandex.chemodan.videostreaming.framework.hls.stats.FFUtilStats;
import ru.yandex.chemodan.videostreaming.framework.media.MediaInfo;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class WithStatsVideoInfoProvider<T> implements HlsVideoInfoProvider<T> {
    private final HlsVideoInfoProvider<T> provider;

    public WithStatsVideoInfoProvider(HlsVideoInfoProvider<T> provider) {
        this.provider = provider;
    }

    @Override
    public MediaInfo getVideoInfo(T sourceMeta) {
        MediaInfo result = provider.getVideoInfo(sourceMeta);
        FFUtilStats.getCurrent().setFileInformation(result);
        return result;
    }
}
