package ru.yandex.chemodan.videostreaming.framework.hls.videoinfo.caching;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.videostreaming.framework.hls.videoinfo.HlsVideoInfoProvider;
import ru.yandex.chemodan.videostreaming.framework.hls.videoinfo.VideoInfoParams;
import ru.yandex.chemodan.videostreaming.framework.media.MediaInfo;
import ru.yandex.chemodan.videostreaming.framework.util.CommonThreadPoolHolder;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class HlsCachingVideoInfoProvider<T> implements HlsVideoInfoProvider<T> {
    private final VideoInfoCache<T> videoInfoCache;

    private final HlsVideoInfoProvider<T> provider;

    private final VideoInfoParams videoInfoParams;

    public HlsCachingVideoInfoProvider(VideoInfoCache<T> videoInfoCache, HlsVideoInfoProvider<T> provider,
            VideoInfoParams videoInfoParams)
    {
        this.videoInfoCache = videoInfoCache;
        this.provider = provider;
        this.videoInfoParams = videoInfoParams;
    }

    @Override
    public MediaInfo getVideoInfo(T sourceMeta) {
        if (videoInfoParams.isCacheDisabled()) {
            return provider.getVideoInfo(sourceMeta);
        }

        Option<MediaInfo> videoInfoO = videoInfoCache.getO(sourceMeta);
        if (videoInfoO.isPresent()) {
            return videoInfoO.get();
        }

        MediaInfo videoInfo = provider.getVideoInfo(sourceMeta);
        CommonThreadPoolHolder.runAsync(() -> videoInfoCache.put(sourceMeta, videoInfo));
        return videoInfo;
    }
}
