package ru.yandex.chemodan.videostreaming.framework.ignite;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collection;
import java.util.Collections;

import org.apache.ignite.configuration.AddressResolver;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class ExternalAddressResolver implements AddressResolver {
    private final ListF<InetAddress> addresses;

    public ExternalAddressResolver() {
        this.addresses = getExternalSafe();
    }

    @Override
    public Collection<InetSocketAddress> getExternalAddresses(InetSocketAddress addr) {
        return addresses.containsTs(addr.getAddress()) ? Collections.singletonList(addr) : Collections.emptyList();
    }

    public boolean isEmpty() {
        return addresses.isEmpty();
    }

    public ListF<InetAddress> getAddresses() {
        return addresses;
    }

    public static ListF<InetAddress> getExternalSafe() {
        try {
            return getExternal();
        } catch (SocketException e) {
            return Cf.list();
        }
    }

    public static ListF<InetAddress> getExternal() throws SocketException {
        return Cf.x(NetworkInterface.getNetworkInterfaces())
                .filter(ExternalAddressResolver::isSuitable)
                .map(ExternalAddressResolver::getSuitableAddresses)
                .toList()
                .flatten();
    }

    private static ListF<InetAddress> getSuitableAddresses(NetworkInterface iface) {
        return Cf.x(iface.getInetAddresses())
                .filter(ExternalAddressResolver::isSuitable)
                .toList();
    }

    private static boolean isSuitable(NetworkInterface iface) {
        try {
            return iface.isUp() && !iface.isLoopback() && !iface.isPointToPoint();
        } catch (SocketException e) {
            return false;
        }
    }

    private static boolean isSuitable(InetAddress addr) {
        return !addr.isLoopbackAddress() && !addr.isSiteLocalAddress() && !addr.isLinkLocalAddress();
    }
}
