package ru.yandex.chemodan.videostreaming.framework.ignite;

import org.apache.ignite.IgniteLogger;
import org.jetbrains.annotations.Nullable;

import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class IcebergIgniteLogger implements IgniteLogger {
    private final Logger logger;

    private final boolean quiet;

    public IcebergIgniteLogger(boolean quiet) {
        this(LoggerFactory.getLogger((String) null), quiet);
    }

    public IcebergIgniteLogger(Logger logger, boolean quiet) {
        this.logger = logger;
        this.quiet = quiet;
    }

    @Override
    public IgniteLogger getLogger(Object ctgr) {
        return new IcebergIgniteLogger(LoggerFactory.getLogger(ctgr != null ? ctgr.toString() : null), quiet);
    }

    @Override
    public void trace(String msg) {
        logger.trace(msg);
    }

    @Override
    public void debug(String msg) {
        logger.debug(msg);
    }

    @Override
    public void info(String msg) {
        logger.info(msg);
    }

    @Override
    public void warning(String msg, @Nullable Throwable e) {
        logger.warn(msg, e);
    }

    @Override
    public void error(String msg, @Nullable Throwable e) {
        logger.error(msg, e);
    }

    @Override
    public boolean isTraceEnabled() {
        return logger.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return logger.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return logger.isInfoEnabled();
    }

    @Override
    public boolean isQuiet() {
        return quiet;
    }

    @Override
    public String fileName() {
        return null;
    }
}
