package ru.yandex.chemodan.videostreaming.framework.m3u;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.videostreaming.framework.media.units.BitRate;
import ru.yandex.misc.image.Dimension;
import ru.yandex.misc.test.Assert;

public class ExtM3UMasterPlaylistTest {
    @Test
    public void mkStringForMasterPlaylist() {
        Assert.equals(
                "#EXTM3U\n"
                        + "#EXT-X-STREAM-INF:PROGRAM-ID=1, BANDWIDTH=1024, RESOLUTION=640x480\n"
                        + "/1.m3u8\n"
                        + "#EXT-X-STREAM-INF:PROGRAM-ID=1, BANDWIDTH=2048, RESOLUTION=1280x960\n"
                        + "/2.m3u8\n",
                new ExtM3UMasterPlaylist(
                        Cf.list(
                                consItem(BitRate.fromKbps(1), new Dimension(640, 480), "/1.m3u8"),
                                consItem(BitRate.fromKbps(2), new Dimension(1280, 960), "/2.m3u8")
                        )
                ).mkString()
        );
    }
    @Test
    public void mkStringForMasterPlaylistWithSeparateAudio() {
        Assert.equals(
                "#EXTM3U\n"
                        + "#EXT-X-STREAM-INF:PROGRAM-ID=1, BANDWIDTH=1024, RESOLUTION=640x480, "
                            + "CODECS=\"avc1.64002a,mp4a.40.2\", AUDIO=\"aac1\"\n"
                        + "/1.m3u8\n"
                        + "#EXT-X-STREAM-INF:PROGRAM-ID=1, BANDWIDTH=2048, RESOLUTION=1280x960, "
                            + "CODECS=\"avc1.64002a,mp4a.40.2\", AUDIO=\"aac2\"\n"
                        + "/2.m3u8\n",
                new ExtM3UMasterPlaylist(
                        Cf.list(
                                consItem(BitRate.fromKbps(1), new Dimension(640, 480), "/1.m3u8",
                                        "aac1"),
                                consItem(BitRate.fromKbps(2), new Dimension(1280, 960), "/2.m3u8",
                                        "aac2")
                        )
                ).mkString()
        );
    }

    private static ExtM3UMasterPlaylist.Stream consItem(BitRate bandwidth, Dimension dimension, String uri) {
        return consItem(bandwidth, dimension, uri, Option.empty());
    }

    private static ExtM3UMasterPlaylist.Stream consItem(BitRate bandwidth, Dimension dimension, String uri,
            String audioName)
    {
        return consItem(bandwidth, dimension, uri, Option.of(audioName));
    }

    private static ExtM3UMasterPlaylist.Stream consItem(BitRate bandwidth, Dimension dimension, String uri,
            Option<String> audioNameO)
    {
        return new ExtM3UMasterPlaylist.Stream(bandwidth, dimension, uri, audioNameO);
    }
}
