package ru.yandex.chemodan.videostreaming.framework.m3u;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class ExtM3UMediaSegment extends DefaultObject {
    public final String uri;

    public final Number duration;

    public final String title;

    public ExtM3UMediaSegment(String uri, Number duration) {
        this(uri, duration, "");
    }

    public ExtM3UMediaSegment(String uri, Number duration, String title) {
        this.uri = uri;
        this.duration = duration;
        this.title = title;
    }

    public static ExtM3UMediaSegment fromTuple(Tuple2<String, Number> uriWithDuration) {
        return new ExtM3UMediaSegment(uriWithDuration.get1(), uriWithDuration.get2());
    }

    public static ListF<ExtM3UMediaSegment> fromTuples(Tuple2List<String, Number> urisWithDurations) {
        return urisWithDurations.toList()
                .map(ExtM3UMediaSegment::fromTuple);
    }
}
