package ru.yandex.chemodan.videostreaming.framework.m3u;

import ru.yandex.bolts.collection.IteratorF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.collection.Tuple2List;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class ExtM3UPlaylists {
    public static ExtM3UMediaPlaylist media(Tuple2List<String, Number> urisWithDurations, boolean completed) {
        return completed
                ? mediaVodAllowCacheEndList(urisWithDurations)
                : mediaForbidCache(urisWithDurations);
    }

    public static ExtM3UMediaPlaylist mediaVodAllowCacheEndList(IteratorF<Tuple2<String, Number>> urisWithDurations) {
        return mediaVodAllowCacheEndList(Tuple2List.wrap(urisWithDurations.toList()));
    }

    private static ExtM3UMediaPlaylist mediaVodAllowCacheEndList(Tuple2List<String, Number> urisWithDurations) {
        return ExtM3UMediaPlaylist.consFromMediaSegments(urisWithDurations)
                .withType(ExtM3UPlaylistType.VOD)
                .allowCache()
                .endList();
    }

    private static ExtM3UMediaPlaylist mediaForbidCache(Tuple2List<String, Number> urisWithDurations) {
        return ExtM3UMediaPlaylist.consFromMediaSegments(urisWithDurations)
                .forbidCache();
    }

    private ExtM3UPlaylists() {}
}
