package ru.yandex.chemodan.videostreaming.framework.m3u;

import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.collection.impl.AbstractPrefetchingIterator;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class ExtM3UPlaylistsTest {
    @Test
    public void generatePlaylist() {
        testMediaVodAllowCacheEndList(
                ""
                        + "#EXTM3U\n"
                        + "#EXT-X-VERSION:3\n"
                        + "#EXT-X-MEDIA-SEQUENCE:0\n"
                        + "#EXT-X-ALLOW-CACHE:YES\n"
                        + "#EXT-X-PLAYLIST-TYPE:VOD\n"
                        + "#EXT-X-TARGETDURATION:5\n"
                        + "#EXTINF:5,\n"
                        + "out0.ts\n"
                        + "#EXTINF:5,\n"
                        + "out1.ts\n"
                        + "#EXTINF:5,\n"
                        + "out2.ts\n"
                        + "#EXTINF:5,\n"
                        + "out3.ts\n"
                        + "#EXTINF:5,\n"
                        + "out4.ts\n"
                        + "#EXTINF:5,\n"
                        + "out5.ts\n"
                        + "#EXTINF:5,\n"
                        + "out6.ts\n"
                        + "#EXTINF:5,\n"
                        + "out7.ts\n"
                        + "#EXTINF:5,\n"
                        + "out8.ts\n"
                        + "#EXTINF:5,\n"
                        + "out9.ts\n"
                        + "#EXTINF:3,\n"
                        + "out10.ts\n"
                        + "#EXT-X-ENDLIST\n",
                11, 5, 3);
    }

    @Test
    public void generatePlaylistStraight() {
        testMediaVodAllowCacheEndList(
                ""
                        + "#EXTM3U\n"
                        + "#EXT-X-VERSION:3\n"
                        + "#EXT-X-MEDIA-SEQUENCE:0\n"
                        + "#EXT-X-ALLOW-CACHE:YES\n"
                        + "#EXT-X-PLAYLIST-TYPE:VOD\n"
                        + "#EXT-X-TARGETDURATION:100\n"
                        + "#EXTINF:100,\n"
                        + "out0.ts\n"
                        + "#EXTINF:100,\n"
                        + "out1.ts\n"
                        + "#EXTINF:100,\n"
                        + "out2.ts\n"
                        + "#EXTINF:100,\n"
                        + "out3.ts\n"
                        + "#EXTINF:100,\n"
                        + "out4.ts\n"
                        + "#EXT-X-ENDLIST\n",
                5, 100, 100
        );
    }

    private static void testMediaVodAllowCacheEndList(String expectedResult,
            int segmentCount, int segmentDuration, int lastSegmentDuration)
    {
        Assert.equals(
                expectedResult,
                ExtM3UPlaylists.mediaVodAllowCacheEndList(
                        new AbstractPrefetchingIterator<Tuple2<String, Number>>() {
                            int i = 0;

                            @Override
                            protected Option<Tuple2<String, Number>> fetchNext() {
                                return consUriAndDurationO(i++);
                            }

                            private Option<Tuple2<String, Number>> consUriAndDurationO(int n) {
                                return Option.when(n < segmentCount, () -> consUriAndDuration(n));
                            }

                            private Tuple2<String, Number> consUriAndDuration(int n) {
                                Number duration = (n + 1) == segmentCount ? lastSegmentDuration : segmentDuration;
                                return new Tuple2<>("out" + n + ".ts", duration);
                            }
                        }
                ).mkString()
        );
    }
}
