package ru.yandex.chemodan.videostreaming.framework.m3u;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.enums.StringEnumResolver;

/**
 * @author Alexei Zakharov
 */
public enum ExtM3uTag implements StringEnum {
    EXTM3U("EXTM3U", true),
    EXTINF("EXTINF", false),
    EXT_X_BYTERANGE("EXT-X-BYTERANGE", false),
    EXT_X_TARGETDURATION("EXT-X-TARGETDURATION", true),
    EXT_X_MEDIA_SEQUENCE("EXT-X-MEDIA-SEQUENCE", true),
    EXT_X_KEY("EXT-X-KEY", false),
    EXT_X_PROGRAM_DATE_TIME("EXT-X-PROGRAM-DATE-TIME", false),
    EXT_X_ALLOW_CACHE("EXT-X-ALLOW-CACHE", true),
    EXT_X_PLAYLIST_TYPE("EXT-X-PLAYLIST-TYPE", true),
    EXT_X_ENDLIST("EXT-X-ENDLIST", true),
    EXT_X_MEDIA("EXT-X-MEDIA", true),
    EXT_X_STREAM_INF("EXT-X-STREAM-INF", false),
    EXT_X_DISCONTINUITY("EXT-X-DISCONTINUITY", false),
    EXT_X_I_FRAMES_ONLY("EXT-X-I-FRAMES-ONLY", true),
    EXT_X_MAP("EXT-X-MAP", false),
    EXT_X_I_FRAME_STREAM_INF("EXT-X-I-FRAME-STREAM-INF", true),
    EXT_X_VERSION("EXT-X-VERSION", true),
    ;

    private String value;

    private boolean standalone;

    ExtM3uTag(String value, boolean standalone) {
        this.value = value;
        this.standalone = standalone;
    }

    @Override
    public String value() {
        return value;
    }

    public boolean isStandalone() {
        return standalone;
    }

    public static final StringEnumResolver<ExtM3uTag> R = new StringEnumResolver<>(ExtM3uTag.class);
}
