package ru.yandex.chemodan.videostreaming.framework.media;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.videostreaming.framework.media.units.FrameRate;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class FrameRates {
    private static final SetF<FrameRate> WIDESPREAD = Cf.set(
            // 24000/1001 FPS
            new FrameRate(24000, 1001),
            new FrameRate(2997, 125),
            new FrameRate(2500000, 104271),
            new FrameRate(10000000, 417083),

            // 24 FPS
            new FrameRate(24, 1),
            new FrameRate(500000, 20833),

            // 25 FPS
            new FrameRate(25, 1),

            // 30000/1001 FPS
            new FrameRate(30000, 1001),
            new FrameRate(2997, 100),
            new FrameRate(10000000, 333667),

            // 30 FPS
            new FrameRate(30, 1),
            new FrameRate(1000000, 33333),
            new FrameRate(10000000, 333333)
    );

    private static final MapF<FrameRate, FrameRate> DERIVED_TO_WIDESPREAD =
            WIDESPREAD.zipWithFlatMap(f -> Cf.list(f, f.divide(4), f.divide(2), f.multiply(2), f.multiply(4)))
                    .invert()
                    .toMap();

    public static Option<FrameRate> getWidespreadByDerived(FrameRate frameRate) {
        return DERIVED_TO_WIDESPREAD.getO(frameRate.toLowest());
    }
}
