package ru.yandex.chemodan.videostreaming.framework.media;

import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.ffprobe.FFprobeInfo;
import ru.yandex.chemodan.videostreaming.framework.ffmpeg.ffprobe.FFprobeSharedFixtures;
import ru.yandex.chemodan.videostreaming.framework.media.units.AspectRatio;
import ru.yandex.misc.image.Dimension;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class MediaInfoTest {
    @Test
    public void calculateAspectRatioIfZero() {
        assertAspectRatioBasedOnDimensionIfStreamsIsIncorrect(
                new Dimension(1920, 1080),
                new AspectRatio(0, 1)
        );
    }

    @Test
    public void calculateAspectRatioIfUndefined() {
        assertAspectRatioBasedOnDimensionIfStreamsIsIncorrect(
                new Dimension(1920, 1080),
                new AspectRatio(0, 0)
        );
    }

    private static void assertAspectRatioBasedOnDimensionIfStreamsIsIncorrect(Dimension dimension,
            AspectRatio streamAspectRatio)
    {
        FFprobeInfo info = new FFprobeInfo(FFprobeSharedFixtures.FORMAT_MKV_1HR,
                FFprobeSharedFixtures.VIDEO_1080P_24FPS.toBuilder()
                        .dimension(dimension)
                        .displayAspectRatio(streamAspectRatio)
                        .build()
        );
        Assert.equals(
                Option.of(AspectRatio.fromDimension(dimension).toFraction()),
                new MediaInfo(info, "{}")
                        .getVideoStream()
                        .getOrCalculateDisplayAspectRatio()
        );
    }
}
