package ru.yandex.chemodan.videostreaming.framework.media;

import org.junit.Test;

import ru.yandex.chemodan.videostreaming.framework.media.units.FrameRate;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class TranscodeFrameRateUtilTest {
    @Test
    public void resolveSameOrDerivedForCloseFrameRates() {
        Assert.equals(
                new FrameRate(30000, 1001),
                TranscodeFrameRateUtil.resolve(
                        new FrameRate(30000, 1001),
                        new FrameRate(30000, 1001)
                )
        );
        Assert.equals(
                new FrameRate(30000, 1001),
                TranscodeFrameRateUtil.resolve(
                        new FrameRate(60000, 1001),
                        new FrameRate(60000, 1001)
                )
        );
        Assert.equals(
                new FrameRate(12347, 500),
                TranscodeFrameRateUtil.resolve(
                        new FrameRate(12345, 500),
                        new FrameRate(12347, 500)
                )
        );
    }

    @Test
    public void resolve() {
        Assert.equals(
                new FrameRate(25),
                TranscodeFrameRateUtil.resolve(
                        new FrameRate(51, 1),
                        new FrameRate(52, 1)
                )
        );
        Assert.equals(
                new FrameRate(30),
                TranscodeFrameRateUtil.resolve(
                        new FrameRate(61, 1),
                        new FrameRate(62, 1)
                )
        );
        Assert.equals(
                new FrameRate(25),
                TranscodeFrameRateUtil.resolve(
                        new FrameRate(26, 1),
                        new FrameRate(27, 1)
                )
        );
        Assert.equals(
                new FrameRate(30),
                TranscodeFrameRateUtil.resolve(
                        new FrameRate(29, 1),
                        new FrameRate(28, 1)
                )
        );
    }
}
