package ru.yandex.chemodan.videostreaming.framework.media.units;

import org.junit.Test;

import ru.yandex.chemodan.util.bender.JsonFieldLevelUnmarshaller;
import ru.yandex.misc.bender.parse.EmptyUnmarshallerContext;
import ru.yandex.misc.bender.parse.JacksonJsonNodeWrapper;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class AbstractFractionUnitTest {
    @Test
    public void unmarshall() {
        JsonFieldLevelUnmarshaller unmarshaller = TestUnit.helper.consUnmarshaller();
        Assert.equals(
                new TestUnit(new Fraction(1, 2)),
                unmarshaller.parseJsonNode(consTextJsonNode("1:2"), new EmptyUnmarshallerContext())
                        .getOrThrow()
        );
    }

    private static class TestUnit extends AbstractFractionUnit<TestUnit> {
        static final Helper<TestUnit> helper = new Helper<>(":", TestUnit::new);

        protected TestUnit(Fraction fraction) {
            super(fraction);
        }

        @Override
        protected Helper<TestUnit> getHelper() {
            return helper;
        }
    }

    private static JacksonJsonNodeWrapper consTextJsonNode(@SuppressWarnings("SameParameterValue") String str) {
        return new JacksonJsonNodeWrapper(new com.fasterxml.jackson.databind.node.TextNode(str));
    }
}
