package ru.yandex.chemodan.videostreaming.framework.media.units;

import lombok.EqualsAndHashCode;

import ru.yandex.chemodan.util.bender.JsonFieldLevelUnmarshaller;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.image.Dimension;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
@EqualsAndHashCode(callSuper = true)
public class AspectRatio extends AbstractFractionUnit<AspectRatio> {
    private static final Helper<AspectRatio> helper = new Helper<>(":", AspectRatio::new);

    public static final JsonFieldLevelUnmarshaller unmarshaller = helper.consUnmarshaller();

    public AspectRatio(int nominator, int denominator) {
        this(new Fraction(nominator, denominator));
    }

    private AspectRatio(Fraction fraction) {
        super(fraction);
    }

    public static AspectRatio fromDimension(Dimension dimension) {
        return new AspectRatio(dimension.getWidth(), dimension.getHeight())
                .toLowest();
    }

    @Override
    protected Helper<AspectRatio> getHelper() {
        return helper;
    }

    public boolean isValid() {
        return isDefined() && !isZero();
    }
}
