package ru.yandex.chemodan.videostreaming.framework.media.units;

import javax.annotation.Nonnull;

import lombok.EqualsAndHashCode;
import lombok.Value;

import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderWrapper;
import ru.yandex.misc.lang.Validate;

/**
 * Copied from ru.yandex.commune.video.format.BitRate with value type changed from int to long
 * as there are values bigger than int can hold.
 *
 * @author Stepan Koltsov
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
@BenderWrapper
@Value
@EqualsAndHashCode(callSuper = false)
public class BitRate extends AbstractMediaUnit implements ExtendedComparable<BitRate> {
    private long bps;

    public BitRate(long bps) {
        Validate.ge(bps, 0L, "bit rate must be non-negative: " + bps);
        this.bps = bps;
    }

    public long getKbps() {
        return getBps() / 1024;
    }

    public static BitRate fromBps(long bps) {
        return new BitRate(bps);
    }

    public static BitRate fromKbps(long kbps) {
        return fromBps(kbps * 1024);
    }

    public Long getBs() {
        return getBps();
    }

    @Override
    public int compareTo(@Nonnull BitRate other) {
        return Long.compare(bps, other.bps);
    }
}
