package ru.yandex.chemodan.videostreaming.framework.media.units;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public interface ExtendedComparable<T> extends Comparable<T> {
    static <T extends Comparable<T>> T min(T comparable1, T comparable2) {
        return comparable1.compareTo(comparable2) <= 0 ? comparable1 : comparable2;
    }

    static <T extends Comparable<T>> T max(T comparable1, T comparable2) {
        return comparable1.compareTo(comparable2) >= 0 ? comparable1 : comparable2;
    }

    default boolean lt(T other) {
        return compareTo(other) < 0;
    }

    default boolean le(T other) {
        return compareTo(other) <= 0;
    }

    default boolean gt(T other) {
        return compareTo(other) > 0;
    }

    default boolean ge(T other) {
        return compareTo(other) >= 0;
    }
}
