package ru.yandex.chemodan.videostreaming.framework.media.units;

import javax.annotation.Nonnull;

import lombok.Value;
import org.junit.Test;

import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class ExtendedComparableTest {
    @Test
    public void lt() {
        Assert.isTrue(
                new TestObject(1)
                        .lt(new TestObject(2))
        );
        Assert.isFalse(
                new TestObject(14)
                        .lt(new TestObject(14))
        );
        Assert.isFalse(
                new TestObject(16)
                        .lt(new TestObject(15))
        );
    }

    @Test
    public void le() {
        Assert.isTrue(
                new TestObject(11)
                        .le(new TestObject(29))
        );
        Assert.isTrue(
                new TestObject(37)
                        .le(new TestObject(37))
        );
        Assert.isFalse(
                new TestObject(101)
                        .le(new TestObject(100))
        );
    }

    @Test
    public void gt() {
        Assert.isTrue(
                new TestObject(10)
                        .gt(new TestObject(8))
        );
        Assert.isFalse(
                new TestObject(21)
                        .gt(new TestObject(21))
        );
        Assert.isFalse(
                new TestObject(22)
                        .gt(new TestObject(50))
        );
    }

    @Test
    public void ge() {
        Assert.isTrue(
                new TestObject(123)
                        .gt(new TestObject(12))
        );
        Assert.isTrue(
                new TestObject(456)
                        .ge(new TestObject(456))
        );
        Assert.isFalse(
                new TestObject(451)
                        .ge(new TestObject(455))
        );
    }

    @Test
    public void max() {
        Assert.equals(
                new TestObject(20),
                ExtendedComparable.max(new TestObject(19), new TestObject(20))
        );
        Assert.equals(
                new TestObject(32),
                ExtendedComparable.max(new TestObject(32), new TestObject(11))
        );
    }

    @Test
    public void min() {
        Assert.equals(
                new TestObject(21),
                ExtendedComparable.min(new TestObject(34), new TestObject(21))
        );
        Assert.equals(
                new TestObject(39),
                ExtendedComparable.min(new TestObject(39), new TestObject(53))
        );
    }

    @Value
    private static class TestObject implements ExtendedComparable<TestObject> {
        int value;

        @Override
        public int compareTo(@Nonnull TestObject o) {
            return Long.compare(value, o.value);
        }
    }
}
