package ru.yandex.chemodan.videostreaming.framework.media.units;

import lombok.EqualsAndHashCode;
import org.jetbrains.annotations.NotNull;

import ru.yandex.chemodan.util.bender.JsonFieldLevelUnmarshaller;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.serialize.ToFieldMarshaller;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
@EqualsAndHashCode(callSuper = true)
public class FrameRate extends AbstractFractionUnit<FrameRate> implements ExtendedComparable<FrameRate> {
    private static final Helper<FrameRate> helper = new Helper<>("/", FrameRate::new);

    public static final JsonFieldLevelUnmarshaller unmarshaller = helper.consUnmarshaller();

    public static final ToFieldMarshaller marshaller = helper.consMarshaller();

    public FrameRate(int nominator) {
        this(nominator, 1);
    }

    public FrameRate(int nominator, int denominator) {
        this(new Fraction(nominator, denominator));
    }

    private FrameRate(Fraction fraction) {
        super(fraction);
    }

    @Override
    protected Helper<FrameRate> getHelper() {
        return helper;
    }

    // TODO: inline (was added to minimize client code changes)
    public String getValue() {
        return toSimpleString();
    }

    @Override
    public int compareTo(@NotNull FrameRate other) {
        return fraction.compareTo(other.fraction);
    }
}
