package ru.yandex.chemodan.videostreaming.framework.media.units;

import org.joda.time.Duration;
import org.junit.Test;

import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class MediaTimeTest {
    @Test
    public void parse() {
        Assert.equals(MediaTime.seconds(1).plus(200000), MediaTime.parse("1.2"));
        Assert.equals(MediaTime.seconds(123).plus(450000), MediaTime.parse("123.45"));
        Assert.equals(MediaTime.seconds(987).plus(654321), MediaTime.parse("987.654321"));
        Assert.equals(MediaTime.seconds(321).plus(123456), MediaTime.parse("321.1234567"));
    }

    @Test
    public void toJodaDuration() {
        Assert.equals(Duration.standardSeconds(10), MediaTime.seconds(10).toJodaDuration());
        Assert.equals(Duration.standardMinutes(123), MediaTime.minutes(123).toJodaDuration());
    }
}
