package ru.yandex.chemodan.videostreaming.framework.media.units;

import lombok.EqualsAndHashCode;
import lombok.Value;

import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderWrapper;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Value
@EqualsAndHashCode(callSuper = false)
@Bendable
@BenderWrapper
public class Rotation extends AbstractMediaUnit {
    int value;

    public int getCcwDegrees() {
        return value;
    }

    public Rotation normalize() {
        int value = this.value % 360;
        if (value < 0) {
            value += 360;
        }
        return new Rotation(value);
    }
}
