package ru.yandex.chemodan.videostreaming.framework.stidblocker;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.commune.dynproperties.DynamicPropertyRegistry;

/**
 * @author friendlyevil
 */
public class DynamicPropertyStidBlocker implements StidBlocker {
    private final DynamicProperty<ListF<String>> blockedStids =
            new DynamicProperty<>("streaming-blocked-stids", Cf.list());

    private final DynamicPropertyRegistry dynamicPropertyRegistry;

    public DynamicPropertyStidBlocker(DynamicPropertyRegistry dynamicPropertyRegistry) {
        this.dynamicPropertyRegistry = dynamicPropertyRegistry;
    }

    @Override
    public boolean isBlocked(String stid) {
        return blockedStids.get().containsTs(stid);
    }

    @Override
    public void block(String stid) {
        SetF<String> stids = Cf.toHashSet(blockedStids.get());
        stids.add(stid);
        dynamicPropertyRegistry.setValue(blockedStids, Cf.toList(stids));
    }

    @Override
    public void unblock(String stid) {
        SetF<String> stids = Cf.toHashSet(blockedStids.get());
        stids.removeTs(stid);
        dynamicPropertyRegistry.setValue(blockedStids, Cf.toList(stids));
    }

    @Override
    public CollectionF<String> getAllBlocked() {
        return blockedStids.get();
    }
}
