package ru.yandex.chemodan.videostreaming.framework.stidblocker;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.SetF;

/**
 * @author friendlyevil
 */
public class InMemoryStidBlocker implements StidBlocker {
    private final SetF<String> blockedStids;

    public InMemoryStidBlocker() {
        this(Cf.hashSet());
    }

    public InMemoryStidBlocker(SetF<String> blockedStids) {
        this.blockedStids = blockedStids;
    }

    @Override
    public boolean isBlocked(String stid) {
        return blockedStids.containsTs(stid);
    }

    @Override
    public void block(String stid) {
        blockedStids.add(stid);
    }

    @Override
    public void unblock(String stid) {
        blockedStids.removeTs(stid);
    }

    @Override
    public CollectionF<String> getAllBlocked() {
        return blockedStids;
    }
}
