package ru.yandex.chemodan.videostreaming.framework.util;

import java.io.ByteArrayInputStream;

import org.junit.Test;

import ru.yandex.misc.io.InputStreamX;
import ru.yandex.misc.random.Random2;
import ru.yandex.misc.test.Assert;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class AsyncCacheableInputStreamSourceTest {
    @Test
    public void testSingleThread() {
        String str = "The power we are dealing here is immeasurable";
        AsyncCacheableInputStreamSource iss = new AsyncCacheableInputStreamSource();
        iss.receiveFrom(new ByteArrayInputStream(str.getBytes()));
        String actualStr = iss.getInputStreamX().readString();
        Assert.equals(str, actualStr);
    }

    @Test
    public void testMultithread() {
        String str = Random2.threadLocal().nextString(1000000);
        AsyncCacheableInputStreamSource iss = new AsyncCacheableInputStreamSource();
        InputStreamX in = iss.getInputStreamX();
        new Thread(() -> iss.receiveFrom(new ByteArrayInputStream(str.getBytes())))
                .start();
        Assert.equals(str, in.readString());
    }
}
