package ru.yandex.chemodan.videostreaming.framework.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

import ru.yandex.chemodan.videostreaming.framework.util.threadlocal.ReplicateThreadLocalsUtil;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class CommonThreadPoolHolder {
    private static final Executor executor = Executors.newCachedThreadPool();

    @SuppressWarnings("UnusedReturnValue")
    public static CompletableFuture<Void> runAsync(Runnable runnable) {
        return CompletableFuture.runAsync(ReplicateThreadLocalsUtil.attachTo(runnable), executor);
    }
}
