package ru.yandex.chemodan.videostreaming.framework.util;

import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

import com.fasterxml.jackson.databind.JsonNode;
import lombok.RequiredArgsConstructor;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;

import ru.yandex.chemodan.util.json.JsonNodeUtils;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.ip.Network;

/**
 * @author Maxim Muzafarov (m-messiah)
 */
@RequiredArgsConstructor
public class HbfApiClient {
    private final String host;
    private final HttpClient httpClient;

    public Set<Network> expandMacro(String macro) {
        String url = String.format("https://%s/macros/%s?format=json", host, macro);
        try {
            return httpClient.execute(new HttpGet(url), HbfApiClient::parseNetworks);
        } catch (IOException e) {
            throw ExceptionUtils.translate(e);
        }
    }

    private static Set<Network> parseNetworks(HttpResponse response) throws IOException {
        JsonNode networks = JsonNodeUtils.getNode(EntityUtils.toString(response.getEntity()));
        return StreamSupport.stream(networks.spliterator(), false)
            .map(JsonNode::asText)
            .filter(HbfApiClient::isNetwork)
            .map(Network::valueOf)
            .collect(Collectors.toSet());
    }

    private static boolean isNetwork(String range) {
        try {
            Network.valueOf(range);
            return true;
        } catch (Exception e) {
            return false;
        }
    }
}
